VERSION ("File Ext 1.0")

'**********************************************************************************************************************
'
'  Sample Program for File ( DAT TYPE ) Commands
'
'  Target Machine : CPT-711
'
'  Commands :
'	EMPTY_TRANSACTION_EX (file%) : To remove all the transaction data from a specified transaction file.
'
'	SAVE_TRANSACTION_EX(file%) : To save (append) a transaction record to the specified transaction file.
'
'     	A% = TRANSACTION_COUNT_EX (file%) : To get the total number of the transaction records saved in the
'						      specified transaction file.
'
'     	UPDATE_TRANSACTION_EX (file%, N%, data$) : To update a transaction record in the specified file.
'
'	DEL_TRANSACTION_DATA_EX (file%, N%) : To remove a block of transaction data from the specified
'						           transaction file.
'
'	A$ = GET_TRANSACTION_DATA_EX$ (file%, N%) : To read a transaction record from the specified file.
'
'  Transaction Files : DAT #1 => Fix data length 12.
'
'**********************************************************************************************************************

	DIM FileDAT$(5)
	File% = 1

100	
	CLS
	LOCATE 1,3
	PRINT "FILE (DAT) TEST"

	EMPTY_TRANSACTION_EX(File%)


'**********     Save Transaction     **********

	FOR i% = 1 TO 5
		FileDAT$(i%) = "APPEND DATA" + STR$(i%)
		SAVE_TRANSACTION_EX(File%, FileDAT$(i%))
	NEXT i%

	LOCATE 3,1
	PRINT "APPEND DATA OK."
			
	GOSUB GetFileRecordToShow
	BEEP(2000,5)
	WAIT(500)


'**********     Update Transaction     **********

	FileD$ = "UPDATE DATA3"
	UPDATE_TRANSACTION_EX(File%, 3, FileD$)

	LOCATE 4,1
	PRINT "UPDATE DATA OK."

	GOSUB GetFileRecordToShow
	BEEP(2000,5)
	WAIT(500)


'**********     Del Transaction     **********

	DEL_TRANSACTION_DATA_EX(File%, 1)	

	LOCATE 5,1
	PRINT "DEL DATA OK."

	GOSUB GetFileRecordToShow
	BEEP(2000,5)

	LOCATE 7,1
	PRINT "PRESS [ENT] KEY"
	INPUT A$	


'**********     Get Transaction Data     **********

	CLS
	LOCATE 1,3
	PRINT "FILE (DAT) TEST"

	GOSUB GetFileRecordToShow

	FOR i% = 1 TO FileRecord%	
		FileDAT$(i%) = GET_TRANSACTION_DATA_EX$(File%, i%)				

		LOCATE i%+2,1
		PRINT FileDAT$(i%)
		WAIT(100)
	NEXT i%	


	LOCATE 7,1
	PRINT "PRESS [ENT] KEY"
	INPUT A$

	GOTO 100


'**********     SUB for showing record number of a file    **********

GetFileRecordToShow:

	FileRecord% = TRANSACTION_COUNT_EX(File%)

	LOCATE 8,10
	PRINT "RECORD:"; FileRecord%
	RETURN

